/* M:/72_INP/15__Interface.jsh
Příliš žluťoučký kůň úpěl ďábelské ó - PŘÍLIŠ ŽLUŤOUČKÝ KŮŇ ÚPĚL ĎÁBELSKÉ Ó

Příkazy a úryvky zadávané ve výpisech v kapitole:
15  Konstrukce interface
/*************************************************************************/


/*
** Výpis 15.0:	Inicializace prostředí – definice pomocných metod a proměnných
********************************************************************/
/set start Start_07.jsh
/reset
/********************************************************************


/*
** Výpis 15.1:	Definice interfejsu IInterfaceTypical
********************************************************************/
/* Kód je uložen v souboru:
M:/72_Java/b72_j21ref/c15_interface/IInterfaceTypical.java
*/
/********************************************************************


/*
** Výpis 15.2:	Definice a použití interfejsu IInterfaceTypical v JShell
********************************************************************/
interface IInterfaceTypical {
    public abstract void methodExp();   // Možná deklarace
    void method();         //Modifikátory nejsou potřeba
}
class IntTImpl_1 implements IInterfaceTypical {
    private static int created = 0;
    private int id = ++created ;
    public String toString() { return "IntTImpl_1(" + id + ")"; }

    IntTImpl_1() { println("Vytvořena instance " + this); }
    public void methodExp() { println("  "+this + ".methodExp()"); }
    public void method()    { println("  "+this + ".method()");    }
}
class IntTImpl_2 implements IInterfaceTypical {
    IntTImpl_2() { println("IntTImpl_2 -- vytvořeno"); }
    public void methodExp() { println("  Zavolána methodExp()"); }
    public void method()    { println("  Zavolána method()");    }
}
void intImplTest(IInterfaceTypical iit) {
    iit.methodExp();
    iit.method();
}
{ intImplTest(new IntTImpl_1());
  intImplTest(new IntTImpl_2()); }
/********************************************************************


/*
** Výpis 15.3:	Definice demonstračního interfejsu IInterfaceFull
 *				obsahujícího všechny povolené typy členů
********************************************************************/
/* Kód je uložen v souboru:
M:/72_Java/b72_j21ref/c15_interface/IInterfaceFull.java
*/
/********************************************************************


/*
** Výpis 15.4:	Demonstrace kolize děděných metod a její řešení
********************************************************************/
interface I1 {
    void mAbstract();
    default void m1d()      { println("I1.m1d()"); }
    default void mDefault() { println("I1.mDefault()"); }
}
interface I2 {
    void mAbstract();
    default void m2d()      { println("I2.m2d()"); }
    void mDefault();
}
class Cls implements I1, I2 {
    public void mAbstract() { println("Cls.mAbstract()"); }
}
interface I2 {
    void mAbstract();
    default void m2d()      { println("I2.m2d()"); }
    default void mDefault() { println("I2"); }
}
class Cls implements I1, I2 {
    public void mAbstract() { println("Cls.mAbstract()"); }
}
class Cls implements I1, I2 {
    public void mAbstract() { println("Cls.mAbstract()"); }
    public void mDefault () { println("Cls.mDefault()");  }
}
/********************************************************************


/*
** Výpis 15.5:	Specifikace předka, jehož metodu volám
********************************************************************/
class Cls2 implements I1, I2 {
    public void mAbstract() { println("Cls2.mAbstract()"); }
    public void mDefault () { I1.super.mDefault(); I2.super.mDefault(); }
    public void m1d      () { I1.super.m1d();  I2.super.m2d();  m2d(); }
}
new Cls2().mDefault();
new Cls2().m1d();
new Cls2().m2d();
/********************************************************************


/*
** Výpis 15.6:	Možné problémy při dědění interfejsů
********************************************************************/
interface I11 extends I1 {
    default void mDefault() { println("I11-2. generace"); }
}
class Cls11 implements I11 {
    public void mAbstract() { mDefault(); I1.super.mDefault(); }
}
interface I12 extends I1, I2 {
}
interface I12 extends I1, I2 {
    default void mDefault () { I1.super.mDefault(); }
}
/********************************************************************


/*
** Výpis 15.7:	Použití dvojtečkového cyklu for (cyklu for-each)
** 				pro iterovatelné objekty
********************************************************************/
List<String> seasons = List.of("Jaro", "Léto", "Podzim", "Zima");
for (String name : seasons) {
    System.out.println(name);
}
/********************************************************************


/*
** Výpis 15.0: Popis
********************************************************************/
                                                               //SYNC
/* Kód je uložen v souboru:
M:/72_Java/b72_j21ref/c15_interface/XXX.java
*/
