package b72_j21ref.c17_inheritance;
/* M:/72_Java/b72_j21ref/c17_inheritance/Square.java
 * Příliš žluťoučký kůň úpěl ďábelské ó - PŘÍLIŠ ŽLUŤOUČKÝ KŮŇ ÚPĚL ĎÁBELSKÉ Ó
 */

import ruplib.canvas.Canvas;
import ruplib.canvas.Rectangle;
import ruplib.util.NamedColor;



/*******************************************************************************
 * Instance třídy {@code Square} představují ...
 * The {@code Square} class instances represent ...
 *
 * @author  Rudolf PECINOVSKÝ
 * @version 2023-Summer
 */
public class Square extends Rectangle
{
    /***************************************************************************
     * Připraví novou instanci s implicitním umístěním, rozměry a barvou.
     */
    Square()
    {
        this(0, 0);
    }

    /***************************************************************************
     * Připraví novou instanci se zadanou pozicí, implicitními rozměry
     * a implicitní barvou.
     *
     * @param x       Vodorovná (x-ová) souřadnice instance,
     *                x=0 má levý okraj plátna, souřadnice roste doprava
     * @param y       Svislá (y-ová) souřadnice instance,
     *                y=0 má horní okraj plátna, souřadnice roste dolů
     */
    Square(int x, int y)
    {
        this(x, y, Canvas.getStep());
    }

    /***************************************************************************
     * Připraví novou instanci se zadanou pozicí a rozměry
     * a implicitní barvou.
     *
     * @param x       Vodorovná (x-ová) souřadnice instance,
     *                x=0 má levý okraj plátna, souřadnice roste doprava
     * @param y       Svislá (y-ová) souřadnice instance,
     *                y=0 má horní okraj plátna, souřadnice roste dolů
     * @param size    Rozměr vytvářené instance,  size &gt; 0
     */
    Square(int x, int y, int size)
    {
//        super(x, y, size, size);
//    //Tělo by bylo možno stejně dobře definovat příkazem
        this(x, y, size, DEFAULT_COLOR);
    }

    /***************************************************************************
     * Připraví novou instanci se zadanou pozicí, rozměry a barvou.
     *
     * @param x       Vodorovná (x-ová) souřadnice instance,
     *                x=0 má levý okraj plátna, souřadnice roste doprava
     * @param y       Svislá (y-ová) souřadnice instance,
     *                y=0 má horní okraj plátna, souřadnice roste dolů
     * @param size    Rozměr vytvářené instance,  size &gt; 0
     * @param color   Barva vytvářené instance
     */
    Square(int x, int y, int size, NamedColor color)
    {
        super(x, y, size, size, color);
    }



//\IA== INSTANCE ABSTRACT METHODS ==============================================
//\IG== INSTANCE GETTERS AND SETTERS ===========================================

    /***************************************************************************
     * Nastaví nové rozměry instance.
     * Nastavovaná šířka a výška musejí mít stejnou velikost
     *
     * @param width    Nově nastavovaná šířka; šířka &gt;= 0
     * @param height   Nově nastavovaná výška; výška &gt;= 0
     * @throws IllegalArgumentException Nemá-li šířka a výška stejnou velikost
     */
    @Override
    public void setSize(int width, int height)
    {
        if (width != height) {
            width = -1;
        }
        super.setSize(width, width);
    }



//\IM== INSTANCE REMAINING NON-PRIVATE METHODS =================================
//\IP== INSTANCE PRIVATE AND AUXILIARY METHODS =================================



//##############################################################################
//\NT== NESTED DATA TYPES ======================================================
}
