/* The file is saved in UTF-8 codepage.
 * Check: «Stereotype», Section mark-§, Copyright-©, Alpha-α, Beta-β, Smile-☺
 */
package b72_j21ref.c19_virtual;

import static b72_j21ref.c19_virtual.Reports19.*;



/*******************************************************************************
 * Instance třídy {@code Granddaughter19} představují vnučky.
 * Třída je součástí skupiny tříd využívajících dědění.
 *
 * @author  Rudolf PECINOVSKÝ
 * @version 2023-Summer
 */
public class Granddaughter19
     extends Daughter19
{
//== CONSTANT CLASS ATTRIBUTES =================================================
//== VARIABLE CLASS ATTRIBUTES =================================================

    /** Počet doposud vytvořených instancí –
     *  tento atribut může být v potomcích zakryt, nicméně zůstane přístupný.*/
    private static int created = 0;



//##############################################################################
//== STATIC INITIALIZER (CLASS CONSTRUCTOR) ====================================
//== CLASS GETTERS AND SETTERS =================================================
//== OTHER NON-PRIVATE CLASS METHODS ===========================================
//== PRIVATE AND AUXILIARY CLASS METHODS =======================================



//##############################################################################
//== CONSTANT INSTANCE ATTRIBUTES ==============================================

    /** Rodné číslo instance = pořadí jejího vzniku v rámci této třídy.
     *  Tento atribut může být v potomcích zakryt, nicméně zůstane přístupný.*/
    protected final String ID = "G"  + ++created + '-' + super.ID;



//== VARIABLE INSTANCE ATTRIBUTES ==============================================



//##############################################################################
//== CONSTRUCTORS AND FACTORY METHODS ==========================================

    /***************************************************************************
     * Konstruktor instance vnučky.
     * Rodičovským podobjektem je virtuální instance třídy {@link Daughter19}.
     */
    public Granddaughter19()
    {
//        constructorReport(this, Granddaughter19.class);
    }



//== ABSTRACT METHODS ==========================================================
//== INSTANCE GETTERS AND SETTERS ==============================================

    /***************************************************************************
     * Virtuální metoda vracející identifikační kód instance {@code this}.
     *
     * @return Identifikační kód ("rodné číslo") instance
     */
    @Override
    public String getID()
    {
        return ID;
    }



//== OTHER NON-PRIVATE INSTANCE METHODS ========================================

    /***************************************************************************
     * Metoda pro demonstraci chování virtuálních metod
     * deklarovaná v matce, nikde nepřebitá.
     * Zakomentovaná verze použitá pro snažší srovnání zdrojových kódů.
     */
//    @Override
//    public void virtualM__()
//    {
//        report( this, "Verze vnučky  - " +
//                      "M__ - Deklarovaná v matce, nikde nepřebitá");
//    }


    /***************************************************************************
     * Metoda pro demonstraci chování virtuálních metod
     * deklarovaná v matce, přebitá dcerou.
     * Zakomentovaná verze použitá pro snažší srovnání zdrojových kódů.
     */
//    @Override
//    public void virtualMD_()
//    {
//        report( this, "Verze vnučky  - " +
//                      "MD_ - Deklarovaná v matce, přebitá dcerou");
//    }


    /***************************************************************************
     * Metoda pro demonstraci chování virtuálních metod
     * deklarovaná v matce, přebitá až vnučkou.
     * Živá verze použitá v demonstračním programu.
     */
    @Override
    public void virtualM_G()
    {
        report( this, "Verze vnučky  - " +
                      "M_G - Deklarovaná v matce, přebitá až vnučkou");
    }


    /***************************************************************************
     * Metoda pro demonstraci chování virtuálních metod
     * deklarovaná v matce, přebitá dcerou i vnučkou.
     * Živá verze použitá v demonstračním programu.
     */
    @Override
    public void virtualMDG()
    {
        report( this, "Verze vnučky  - " +
                      "MDG - Deklarovaná v matce, přebitá dcerou i vnučkou");
    }


    /***************************************************************************
     * Metoda pro demonstraci chování virtuálních metod
     * deklarovaná v dceři, nikde nepřebitá.
     * Zakomentovaná verze použitá pro snažší srovnání zdrojových kódů.
     */
//    @Override
//    public void virtual_D_()
//    {
//        report( this, "Verze vnučky  - " +
//                      "_D_ - Deklarovaná v dceři, nikde nepřebitá");
//    }


    /***************************************************************************
     * Metoda pro demonstraci chování virtuálních metod
     * deklarovaná v dceři, přebitá vnučkou.
     * Živá verze použitá v demonstračním programu.
     */
    @Override
    public void virtual_DG()
    {
        report( this, "Verze vnučky  - " +
                      "_DG - Deklarovaná v dceři, přebitá vnučkou");
    }


    /***************************************************************************
     * Metoda pro demonstraci chování virtuálních metod
     * deklarovaná ve vnučce, nikde nepřebitá.
     * Živá verze použitá v demonstračním programu.
     */
//    @Override
    public void virtual__G()
    {
        report( this, "Verze vnučky  - " +
                      "__G - Deklarovaná ve vnučce, nikde nepřebitá");
    }


    /***************************************************************************
     * Metoda postupně zavolá všechny virtuální metody své instance.
     * Tato verze volá všechny metody explicitně.
     */
    public final void summaryGe()
    {
        System.out.println("Explicitní volání virtuálních metod třídy: " +
                           Granddaughter19.class.getSimpleName());
         this.virtualM__();      this.virtualMD_();
         this.virtualM_G();      this.virtualMDG();
         this.virtual_D_();      this.virtual_DG ();
         this.virtual__G();
    }


    /***************************************************************************
     * Vrátí textový podpis instance, tj. její řetězcovou reprezentaci.
     *
     * @return Textová reprezentace (podpis) dané instance
     */
    @Override
    public String toString()
    {
        return "Granddaughter19_" + ID + "(" + super.toString() + ")";
    }



//== PRIVATE AND AUXILIARY INSTANCE METHODS ====================================



//##############################################################################
//== NESTED DATA TYPES =========================================================
}
