/* The file is saved in UTF-8 codepage.
 * Check: «Stereotype», Section mark-§, Copyright-©, Alpha-α, Beta-β, Smile-☺
 */
package b72_j21ref.c19_virtual;

import java.util.Arrays;



/*******************************************************************************
 * Knihovní třída {@code Reports19} obsahuje sadu metod sloužících k demonstraci
 * průběhu některých činností při konstrukci objektů a jejich používání.
 *
 * @author  Rudolf PECINOVSKÝ
 * @version 2023-Summer
 */
public class Reports19
{
//== CONSTANT CLASS ATTRIBUTES =================================================
//== VARIABLE CLASS ATTRIBUTES =================================================



//##############################################################################
//== STATIC INITIALIZER (CLASS CONSTRUCTOR) ====================================
//== CLASS GETTERS AND SETTERS =================================================
//== OTHER NON-PRIVATE CLASS METHODS ===========================================

    /***************************************************************************
     * Metoda pro výpis zprávy konstruktoru o typu konstruovaného objektu
     * spolu s typem aktuálně konstruovaného podobjektu.
     *
     * @param instance Instance výsledného konstruovaného objektu
     * @param cls      Class-objekt třídy volajícího konstruktoru
     */
    public static void constructorReport(Object instance, Class<?> cls)
    {
        Class<?> instanceCls = instance.getClass();
        boolean  topType     = instanceCls.equals(cls);
        String callingClass  = cls        .getSimpleName();
        String instanceClass = instanceCls.getSimpleName();
        String indent        = "                        "
                             .substring(0, callingClass.length()+2);
        System.out.println(callingClass + ": Vytvářím " + instance + "\n"+
                (topType ? ""
                         : indent + "jako rodičovský podobjekt objektu typu " +
                           instanceClass));
    }


    /***************************************************************************
     * Pomocná metoda -- vytiskne argument na standardní výstup
     * a vrátí jej jako funkční hodnotu.
     *
     * @param input Tištěný a vracený objekt
     * @return Argument
     */
    public static String intermezzo(String input)
    {
        System.out.println(input);
        return input;
    }


    /***************************************************************************
     * Vytiskne podpis argumentu na standardní výstup.
     *
     * @param object Tištěný objekt
     */
    public static void println(Object object)
    {
        System.out.println(object);
    }


    /***************************************************************************
     * Vypíše na standardní výstup zprávu obsahující
     * podpis objektu zadaného v prvním parametru a text zadaný v druhém.
     *
     * @param instance Instance, pro níž se vypisuje
     * @param message  Zpráva, která se má vypsat
     */
    public static void report(Object instance, String message)
    {
        System.out.println("\n  Instance: " + instance +
                           "\n  Zpráva:   " + message);
    }


    /***************************************************************************
     * Vypíše na standardní výstup zprávu obsahující
     * název třídy, jejíž class-objekt je zadaný v prvním parametru
     * a poté spustí seznam metod zadaný v druhém parametru.
     *
     * @param <T>     Typ, jehož metoda tuto metodu zavolala
     * @param cls     Class-objekt typu, jehož metoda tuto metodu zavolala
     * @param methods Metody, které se budou postupně volat
     */
    public static <T extends Mother19>
           void multireport(Class<T> cls, Runnable... methods)
    {
        System.out.println("Výpis ze třídy: " + cls.getSimpleName());
        Arrays.stream(methods).forEach(m -> m.run());
    }



//== PRIVATE AND AUXILIARY CLASS METHODS =======================================



//##############################################################################
//== CONSTANT INSTANCE ATTRIBUTES ==============================================
//== VARIABLE INSTANCE ATTRIBUTES ==============================================



//##############################################################################
//== CONSTRUCTORS AND FACTORY METHODS ==========================================

    /***************************************************************************
     * Soukromý konstruktor zabraňující vytvoření instance.
     */
    private Reports19()
    {
    }



//== ABSTRACT METHODS ==========================================================
//== INSTANCE GETTERS AND SETTERS ==============================================
//== OTHER NON-PRIVATE INSTANCE METHODS ========================================
//== PRIVATE AND AUXILIARY INSTANCE METHODS ====================================



//##############################################################################
//== NESTED DATA TYPES =========================================================
}
