package b72_j21ref.c22_generics;
/* M:/72_Java/b72_j21ref/c22_generics/package-info.java
 * Příliš žluťoučký kůň úpěl ďábelské ó - PŘÍLIŠ ŽLUŤOUČKÝ KŮŇ ÚPĚL ĎÁBELSKÉ Ó
 */


/*******************************************************************************
 * Instance třídy {@code GenericCrate2} slouží jako univerzální přepravky
 * uchovávající dvě hodnoty zadaných typů.
 *
 * Pro demonstraci možností generických typů je tento typ definován jako
 * proměnný, takže umožňuje i změnu uchovávaných hodnot.
 * Tato verze používá typové parametry, takže překladač může kontrolovat,
 * zda uživatel neudělal omylem chybu.
 *
 * @param <V1> Typ první ukládané hodnoty
 * @param <V2> Typ druhé ukládané hodnoty
 *
 * @author  Rudolf PECINOVSKÝ
 * @version 2023-Summer
 */
public class GenericCrate2<V1, V2>
{
    private static int created = 0;
    private final  int ID = ++created;

    private V1 v1;      //První uchovávaná hodnota
    private V2 v2;      //Druhá uchovávaná hodnota

    public GenericCrate2(V1 v1, V2 v2)
    {
        this.v1 = v1;
        this.v2 = v2;
    }

    public V1 getV1() { return v1; }
    public V2 getV2() { return v2; }

    public void setV1(V1 v1) { this.v1 = v1; }
    public void setV2(V2 v2) { this.v2 = v2; }

    public GenericCrate2<V1, V2> shallowCopy() {
        return new GenericCrate2<>(v1, v2);
//        return new GenericCrate2(new V1(), new V2())
    }

    @Override
    public String toString() {
        return "GenericCrate2_" + ID +
               "{v1=(" + v1.getClass().getSimpleName() + ")" + v1 +
              ", v2=(" + v2.getClass().getSimpleName() + ")" + v2 + '}';
    }
}
