package b72_j21ref.c22_generics;
/* M:/72_Java/b72_j21ref/c22_generics/package-info.java
 * Příliš žluťoučký kůň úpěl ďábelské ó - PŘÍLIŠ ŽLUŤOUČKÝ KŮŇ ÚPĚL ĎÁBELSKÉ Ó
 */

import ruplib.canvasmanager.Ellipse;
import ruplib.canvasmanager.Rectangle;
import ruplib.geom.IShape;

import ruplib.util.NamedColor;



/*******************************************************************************
 * ITovární třída {@code GenericMethods} slouží k demonstraci
 * definice a použití generických metod.
 *
 * @author  Rudolf PECINOVSKÝ
 * @version 2023-Summer
 */
public class GenericMethods
{
//== OTHER NON-PRIVATE CLASS METHODS ===========================================

    /***************************************************************************
     * Zkopíruje hodnoty uložené v jedné přepravce do druhé přepravky,
     * tj.přiřadí atributům parametru {@code dest}
     * hodnoty atributů parametru {@code source}.
     *
     * @param <T1>   Typ prvního parametru obou přepravek
     * @param <T2>   TypDruhého parametru obou přepravek
     * @param dest   Cílová přepravka, do níž se hodnoty ukládají
     * @param source Zdrojová přepravka, odkud se hodnoty berou
     */
    public static <T1, T2> void assignContent(GenericCrate2<T1, T2> dest,
                                              GenericCrate2<T1, T2> source)
    {
        System.out.println("Do proměnné: " + dest +
                           "  přiřadíme: " + source);
        dest.setV1(source.getV1());
        dest.setV2(source.getV2());
        System.out.println("   výsledek: " + dest);
    }



//##############################################################################
//== CONSTRUCTORS AND FACTORY METHODS ==========================================

    /***************************************************************************
     *
     */
    public GenericMethods()
    {
    }



//##############################################################################
//== TESTING CLASSES AND METHODS ===============================================

    /***************************************************************************
     * Demonstruje používání generických metod a jejich typových parametrů
     */
    @SuppressWarnings({"unchecked", "rawtypes"})
    public static void testAssignContent()
    {
        GenericCrate2<Rectangle, Ellipse>  re_el_1;
        GenericCrate2<Rectangle, Ellipse>  re_el_2;
        GenericCrate2<IShape,    IShape>   sh_sh_1;
        GenericCrate2<IShape,    IShape>   sh_sh_2;

        Rectangle r1 = new Rectangle();
        Ellipse   e1 = new Ellipse  ();
        Rectangle r2 = new Rectangle(100, 100, 100, 100, NamedColor.SMOKY);
        Ellipse   e2 = new Ellipse  (100, 100, 100, 100, NamedColor.MILKY);

        re_el_1 = new GenericCrate2<>(r1, e1);
        re_el_2 = new GenericCrate2<>(r2, e2);
    //    re_el_2 = new GenericCrate2<>(e2, r2);    //Nesedí typy
        System.out.println("Vytvořeny přepravky:\n  re_el_1=" + re_el_1 +
                                               "\n  re_el_2 " + re_el_2);

        assignContent(re_el_2, re_el_1);
        System.out.println("Po přiřazení:\n  re_el_1=" + re_el_1);

        sh_sh_1 = new GenericCrate2<>(r1, e1);    //Nesedí typy


        sh_sh_1 = new GenericCrate2<>((IShape)r1, (IShape)e1);
        sh_sh_2 = new GenericCrate2<IShape,IShape>(r2, e2);
        System.out.println("Vytvořeny přepravky:\n  sh_sh_1=" + sh_sh_1 +
                                               "\n  sh_sh_2 " + sh_sh_2);
        assignContent(sh_sh_2, sh_sh_1);
        System.out.println("Po přiřazení:\n  sh_sh_1=" + sh_sh_1);

    //    assignContent(sh_sh_1, re_el_1);      //Nesedí mu typy
          assignContent(sh_sh_1, (GenericCrate2)re_el_1);

        sh_sh_2 = new GenericCrate2<IShape,IShape>(r1, e2);
        System.out.println("Vytvořena přepravka:\n  sh_sh_1=" + sh_sh_1);

        //Přiřazení se zadáním typových argumentů
        GenericMethods.<IShape,IShape>assignContent(sh_sh_1, sh_sh_2);
        System.out.println("Po přiřazení:\n  sh_sh_1=" + sh_sh_1);
    }


    /***************************************************************************
     * Hlavní metoda spouštějící celou aplikaci
     *
     * @param args Parametry příkazového řádku - zde nepoužité.
     */
    public static void main(String[] args)
    {
        testAssignContent();
    }

}
