package b72_j21ref.c22_generics;
/* M:/72_Java/b72_j21ref/c22_generics/package-info.java
 * Příliš žluťoučký kůň úpěl ďábelské ó - PŘÍLIŠ ŽLUŤOUČKÝ KŮŇ ÚPĚL ĎÁBELSKÉ Ó
 */


/****************************************************************************
 * Instance třídy {@code ObjectCrate2} slouží jako univerzální přepravky
 * uchovávající dvě hodnoty objektových typů.
 * Pro demonstraci možností generických typů je tento typ definován jako
 * proměnný, takže umožňuje i změnu uchovávaných hodnot.
 * Tato verze nepoužívá typové parametry,
 * takže překladač nemůže kontrolovat, zda uživatel neudělal omylem chybu.
 *
 * @author  Rudolf PECINOVSKÝ
 * @version 2023-Summer
 */
public class ObjectCrate2
{
    private static int created = 0;
    private final  int ID = ++created;

    private Object v1;      //První uchovávaná hodnota
    private Object v2;      //Druhá uchovávaná hodnota

    public ObjectCrate2(Object v1, Object v2)
    {
        this.v1 = v1;
        this.v2 = v2;
    }

    public Object getV1() { return v1; }
    public Object getV2() { return v2; }

    public void setV1(Object v1) { this.v1 = v1; }
    public void setV2(Object v2) { this.v2 = v2; }

    public ObjectCrate2 shallowCopy() {
        return new ObjectCrate2(v1, v2);
//        return new ObjectCrate2(new Object(), new Object())
    }

    @Override public String toString() {
        return "ObjectCrate2_" + ID +
               "{v1=(" + v1.getClass().getSimpleName() + ")" + v1 +
              ", v2=(" + v2.getClass().getSimpleName() + ")" + v2 + '}';
    }
}
