package b72_j21ref.c23_typearguments;
/* M:/72_Java/b72_j21ref/c23_typearguments/Interval_Full.java
 * Příliš žluťoučký kůň úpěl ďábelské ó - PŘÍLIŠ ŽLUŤOUČKÝ KŮŇ ÚPĚL ĎÁBELSKÉ Ó
 */


/****************************************************************************
 * Instance třídy {@code Interval} představují uzavřené intervaly
 * porovnatelných objektů, tj. objektů implementujících interfejs
 * {@link Comparable}{@code <T>},
 * kde {@code T} je současně typovým parametrem daného intervalu.
 *
 * @param <T> Typ porovnávaných objektů
 *
 * @author  Rudolf PECINOVSKÝ
 * @version 2023-Summer
 */
@SuppressWarnings("overrides")
public class Interval_Full <T extends Comparable<? super T>>
{
//###########################################################################
//\IC== INSTANCE CONSTANTS (CONSTANT INSTANCE ATTRIBUTES/FIELDS) ============

    /** Dolní mez intervalu. */
    private final T lowerEndpoint;

    /** Horní mez intervalu. */
    private final T upperEndpoint;



//###########################################################################
//\II== INSTANCE INITIALIZERS (CONSTRUCTORS) ================================

    /************************************************************************
     * Vytvoří uzavřený interval se zadanými mezemi.
     *
     * @param from  Dolní mez vytvářeného intervalu
     * @param to    Horní mez vytvářeného intervalu
     */
    public Interval_Full(T from, T to)
    {
        lowerEndpoint = from;
        upperEndpoint = to;
    }


//\IG== INSTANCE GETTERS AND SETTERS ========================================

    /************************************************************************
     * Vrátí dolní mez intervalu.
     *
     * @return Dolní mez intervalu
     */
    public T getLowerEndpoint()
    {
        return lowerEndpoint;
    }


    /************************************************************************
     * Vrátí horní mez intervalu.
     *
     * @return Horní mez intervalu
     */
    public T getUpperEndpoint()
    {
        return upperEndpoint;
    }



//\IM== INSTANCE REMAINING NON-PRIVATE METHODS ==============================

    /************************************************************************
     * Vrátí informaci o tom, zda je interval zadaný v parametru
     * podintervalem daného intervalu, tj. zda je množina hodnot spadajících
     * do intervalu zadaného v parametru podmnožinou hodnot daného intervalu.
     *
     * @param  interval Testovaný interval
     * @return Je-li interval zadaný v parametru podintervalem daného
     *         intervalu, vrátí {@code true}, jinak vrací {@code false}
     */
    public boolean contains(Interval_Full<? extends T> interval)
    {
        return inside(interval.lowerEndpoint)  &&
               inside(interval.upperEndpoint);
    }


    /************************************************************************
     * Vrátí informaci o tom, zda je daný interval podintervalem intervalu
     * zadaného v parametru, tj. zda je množina hodnot spadajících
     * do daného intervalu podmnožinou hodnot intervalu zadaného v parametru.
     *
     * @param  interval Testovaný interval
     * @return Je-li daný interval podintervalem intervalu zadaného
     *         v argumentu, vrátí {@code true}, jinak vrací {@code false}
     */
    public boolean isContainedIn(Interval_Full<? super T> interval)
    {
        return interval.inside(lowerEndpoint)  &&
               interval.inside(upperEndpoint);
    }


    /************************************************************************
     * Vrátí vrátí uzavřený interval, který je průnikem daného intervalu
     * a intervalu zadaného v parametru, tj. interval obsahující objekty
     * spadající do obou intervalů.
     *
     * @param  interval Druhý interval
     * @return Je-li daný interval podintervalem intervalu zadaného
     *         v argumentu, vrátí {@code true}, jinak vrací {@code false}
     */
    public Interval_Full<T> intersection(Interval_Full<? extends T> interval)
    {
        return new Interval_Full<>(
                   MathT.max(this.lowerEndpoint, interval.lowerEndpoint),
                   MathT.min(this.upperEndpoint, interval.upperEndpoint));
    }


    /************************************************************************
     * Vrátí informaci o tom, spadá-li zadaný objekt do daného intervalu.
     *
     * @param  object Testovaný objekt
     * @return Spadá-li zadaný do daného intervalu, vrátí {@code true},
     *         jinak vrací {@code false}
     */
    public boolean inside(T object)
    {
        return (lowerEndpoint.compareTo(object) <= 0)  &&
               (upperEndpoint.compareTo(object) >= 0);
    }


    /************************************************************************
     * Vrátí informaci o tom, je-li daný interval shodný s intervalem
     * zadaným v parametru.
     *
     * @param  obj Porovnávaný interval
     * @return Jsou-li intervaly shodné, vrátí {@code true},
     *         v opačném případě vrátí {@code false}
     */
    @Override
    public boolean equals(Object obj)
    {
        return (obj != null)  &&
                obj instanceof Interval_Full  &&
               this.lowerEndpoint.equals(((Interval_Full)obj).lowerEndpoint)  &&
               this.upperEndpoint.equals(((Interval_Full)obj).upperEndpoint);
    }


    /************************************************************************
     * Vrátí textový podpis objektu.
     *
     * @return Hodnoty dolní a horní meze oddělené středníkem
     *         a uzavřené v hranatých závorkách
     */
    @Override
    public String toString()
    {
        return "[" + lowerEndpoint + "; " + upperEndpoint + "]";
    }

}
