package b72_j21ref.c24_nestedtypes;
/* M:/72_Java/b72_j21ref/c24_nestedtypes/SparseArray.java
 * Příliš žluťoučký kůň úpěl ďábelské ó - PŘÍLIŠ ŽLUŤOUČKÝ KŮŇ ÚPĚL ĎÁBELSKÉ Ó
 */

import java.util.Iterator;
import java.util.NoSuchElementException;


/****************************************************************************
 * Instance třídy {@code SparseArray} představují řídká pole.
 */
public class SparseArray implements Iterable<SparseArray.Element>
{
    private final int[] elements;
    private final int   eLenght;


    /** Vytvoří řídké pole obsahující zadaná čísla.
     * @param elements Čísla vkládaná do vytvářeného pole
     */
    public SparseArray(int... elements)
    {
        this.elements = elements;
        this.eLenght  = elements.length;
    }

    /** Vrátí nový iterátor procházející prvky pole. */
    @Override
    public Iterator<Element> iterator()
    {
        return this.new SAIterator();
    }


//###########################################################################
//\NT== NESTED DATA TYPES ===================================================

    /************************************************************************
     * Přepravka uchovávající hodnotu spolu s jejím indexem v poli.
     */
    public static class Element
    {
        final int index;
        final int value;

        /********************************************************************
         * Vytvoří prvek se zadaným indexem a hodnotou.
         * @param index Index vytvářeného prvku
         * @param value Hodnota vytvářeného prvku
         */
        public Element(int index, int value)
        {
            this.index = index;
            this.value = value;
        }
    }//Konec definice vnořené třídy SparseArray.Element


    /************************************************************************
     * Iterátor vracející pouze elementy reprezentující nenulové prvky.
     */
    private class SAIterator implements Iterator<SparseArray.Element>
    {
        private int index;

        /** Vytvoří iterátor a nastaví jej na první nenulový prvek. */
        public SAIterator()
        {
            index = -1;
            findNext();
        }

        /** Vrátí informaci o tom, existuje-li ještě nezpracovaný prvek. */
        @Override
        public boolean hasNext()
        {
            return (index < eLenght);
        }

        /** Vrátí další nezpracovaný prvek. */
        @Override
        public Element next()
        {
            if (index >= eLenght) {
                throw new NoSuchElementException("Všechny prvky vyčerpány");
            }
            Element e = new Element(index, elements[index]);
            findNext();
            return e;
        }

        /** Najde další nenulový prvek a nastaví na něj index;
         *  není-li takový, bude index ukazovat za poslední prvek. */
        private void findNext()
        {
            for (int i = index+1;   i < eLenght;   i++) {
                int ei = elements[i];
                if (elements[i] != 0) {
                    index = i;
                    return;
                }
            }
            index = eLenght;
        }
    }//Konec definice vnitřní třídy SparseArray.SAIterator
}//Konec definice třídy SparseArray
