package b72_j21ref.c26_records;
/* M:/72_Java/b72_j21ref/c26_records/ITriangleSSS.java
 * Příliš žluťoučký kůň úpěl ďábelské ó - PŘÍLIŠ ŽLUŤOUČKÝ KŮŇ ÚPĚL ĎÁBELSKÉ Ó
 */

import java.util.Arrays;
import java.util.Objects;

/****************************************************************************
 * Instance interfejsu {@code ITriangleSSS} představují
 * obecné trojúhelníky definované podle věty SSS, tj. délkami svých stran.
 *
 * @author  Rudolf PECINOVSKÝ
 * @version 20230-Summer
 */
public interface ITriangleSSS extends IArea
{
    double a();
    double b();
    double c();

    /** Vrátí velikost plochy trojúhelníku. */
    default public double area()  {
        double s = (a() + b() + c()) / 2;
        return Math.sqrt(s * (s - a()) * (s - b()) * (s - c()));
    }

    /* Při porovnávání instancí kontroluje pouze délky stran. */
    default public boolean eq(Object o)  {
        if (this == o) { return true; }
        if (o instanceof ITriangleSSS t) {
            var result = false;
            double[] thisa = sortedLengths(this);
            double[] other = sortedLengths(t);
            result = (thisa[0] == other[0])  &&  (thisa[1] == other[1])
                                             &&  (thisa[2] == other[2]);
            return result;
        }
        return false;
    }

    /** Společná definice hash-kódu. */
    default public int hc()  {
        double[] sites = sortedLengths(this);
        return Objects.hash(sites[0], sites[1], sites[2]);
    }

    /** Vrátí vektor setříděných délek stran. */
    private static double[] sortedLengths(ITriangleSSS t)  {
        double[] lengths = {t.a(), t.b(), t.c()};
        Arrays.sort(lengths);
        return lengths;
    }
}
