package b72_j21ref.c26_records;
/* M:/72_Java/b72_j21ref/c26_records/RectangularTriangleSSS.java
 * Příliš žluťoučký kůň úpěl ďábelské ó - PŘÍLIŠ ŽLUŤOUČKÝ KŮŇ ÚPĚL ĎÁBELSKÉ Ó
 */


/***************************************************************************
 * Pravoúhlý trojúhelník definovaný délkami stran podle věty SSS.
 */
public record RectangularTriangleSSS(double a, double b, double c, long ID)
implements ITriangleSSS
{
    private static final long MI = System.currentTimeMillis();
    private static int count = 0;

    /** Vytvoří záznam o trojúhelníku zadaném délkami svých stran. */
    public RectangularTriangleSSS(double a, double b, double c, long ID) {
        if (ID != MI) {
            throw new IllegalArgumentException(
                "\nPoužívání konstruktoru zadávajícího všechny délky stran"
              + " je zakázáno!");
        }
        this.a = a;    this.b = b;    this.c = c;   //Musíme inicializovat
        this.ID = ++count;  // Rodné číslo instance
    }

    /** Vytvoří záznam o pravoúhlém trojúhelníku zadaném délkou odvěsen. */
    public RectangularTriangleSSS(double a, double b) {
        this(a, b, Math.sqrt(a*a + b*b), MI);
    }

    /** Vytvoří záznam o rovnoramenném trojúhelníku zadaném délkou přepony. */
    public RectangularTriangleSSS(double c) {
        this(Math.sqrt(c*c / 2), Math.sqrt(c*c / 2), c, MI);
    }

    /** Vrátí velikost plochy trojúhelníka. */
    @Override public double area() {
        return a() * b() / 2;
    }

    /** Porovná instanci se zadanou. */
    @Override public boolean equals(Object o) {
        return eq(o);
    }

    /** Generuje heškód závisející pouze na délkách stran. */
    @Override public int hashCode() {
        return hc();
    }
}
