package b72_j21ref.c28_lambda;
/* M:/72_Java/b72_j21ref/c28_lambda/BlinkingLightTest.java
 * Příliš žluťoučký kůň úpěl ďábelské ó - PŘÍLIŠ ŽLUŤOUČKÝ KŮŇ ÚPĚL ĎÁBELSKÉ Ó
 */

//import org.junit.jupiter.api.AfterEach;
//import org.junit.jupiter.api.AfterAll;
//import org.junit.jupiter.api.BeforeEach;
//import org.junit.jupiter.api.BeforeAll;
//import org.junit.jupiter.api.Test;
//import org.junit.jupiter.api.TestInfo;
//
//import static org.junit.jupiter.api.Assertions.*;



/*******************************************************************************
 * Testovací třída {@code BlinkingLightTest} definuje sadu jednotkových testů
 * prověřujících definici třídy {@link BlinkingLight}.
 * Pro odkomentování třídy je třeba instalovat knihovnu pro JUnit 6.
 *
 * @author  Rudolf PECINOVSKÝ
 * @version Reference
 */
public class BlinkingLightTest
{
////== CONSTANT CLASS ATTRIBUTES =================================================
//
//    /** Správce plátna mající na starosti zobrazování objektů na plátně. */
//    private static final CanvasManager CM = CanvasManager.getInstance();
//
//
//
////== VARIABLE CLASS ATTRIBUTES =================================================
//
//    /** Zpravodaj zprostředkující odsazovaný tisk na standardní výstup. */
//    private static IndentingReporter IR;
//
//
//
////##############################################################################
////== PREPARATION AND CLEAN UP OF THE TEST FIXTURE ==============================
//
//    /***************************************************************************
//     * Provede akce, které je třeba vykonat před spuštěním bloku testů
//     * definovaných v této třídě.
//     */
//    @BeforeAll
//    public static void setUpClass()
//    {
//        IR = IndentingReporter.getSystemReporter();
//        IR.reportStart(BlinkingLightTest.class.toString());
//    }
//
//
//    /***************************************************************************
//     * Provede akce, které je třeba vykonat po ukončení bloku testů
//     * definovaných v této třídě.
//     */
//    @AfterAll
//    public static void tearDownClass()
//    {
//        IR.reportEnd();
//        IndentingReporter.returnSystemOut();
//    }
//
//
//    /***************************************************************************
//     * Inicializace předcházející spuštění každého testu a připravující tzv.
//     * přípravek (fixture), což je sada objektů, s nimiž budou testy pracovat.
//     */
//    @AfterEach
//    public void setUp(TestInfo info)
//    {
//        IR.reportStart("START: " + info.getDisplayName());
//
//        lightXYS  = new BlinkingLight(  0,   0, 100);
//        lightXY   = new BlinkingLight(100,  50);
//        lightXYC  = new BlinkingLight( 50, 100,      NamedColor.RED);
//        lightXYSC = new BlinkingLight(100, 100, 100, NamedColor.GREEN);
//
//        CM.add(lightXYS, lightXY, lightXYC, lightXYSC);
//        IO.inform("Test: " + info.getDisplayName() + "\nPřípravek vytvořen");
//    }
//
//
//    /***************************************************************************
//     * Provede akce, které je třeba vykonat po ukončení každého testu
//     * definovaného v této třídě.
//     */
//    @AfterEach
//    public void tearDown(TestInfo info)
//    {
//        IO.inform("END: " + info.getDisplayName() + "\nKonec testu");
//        CM.removeAll();
//        IR.reportEnd("END: " + info.getDisplayName());
//    }
//
//
//
////##############################################################################
////== VARIABLE INSTANCE ATTRIBUTES ==============================================
//
//    private BlinkingLight lightXY;
//    private BlinkingLight lightXYS;
//    private BlinkingLight lightXYC;
//    private BlinkingLight lightXYSC;
//
//
//
////##############################################################################
////== PRIVATE AND AUXILIARY INSTANCE METHODS ====================================
//
//    /**************************************************************************
//     * Vrátí světlo se stejnou pozicí, rozměrem a barvou,
//     * ale tvořené zadaným obrazcem.
//     *
//     * @param  <T>        Specifikace požadavků na typ obrazce
//     * @param  light      Původní světlo
//     * @param  shapeMaker Tovární objekt obrazců
//     * @return Světlo s vyměněným obrazcem
//     */
//private <T extends ICMShape & IColorable>
//        BlinkingLight changeShape(BlinkingLight light, Supplier<T> shapeMaker)
//{
//    Position   position = light.getPosition();
//    Size       size     = light.getSize();
//    NamedColor color    = light.getColor();
//
//    BlinkingLight result = new BlinkingLight(position.x, position.y, size.width, color,
//                             shapeMaker);
//    return result;
//}
//
//
//
////##############################################################################
////== TESTS PROPER ==============================================================
//
//         /**********************************************************************
//          * Nechá všechna vytvořená světla bliknout
//          */
//         @Test
//         public void testBlinking()
//         {
//             lightXY  .switchOff();
//             lightXYS .switchOff();
//             lightXYC .switchOff();
//             lightXYSC.switchOff();
//
//             lightXY  .blink();
//             lightXYS .blink();
//             lightXYC .blink();
//             lightXYSC.blink();
//
//             lightXY  .switchOn();
//             lightXYS .switchOn();
//             lightXYC .switchOn();
//             lightXYSC.switchOn();
//         }
//
//
//    /********************************************************************
//     * Vyrobí ze světel mnohotvar a ověří jeho funkci
//     * při změně rozměru a s ní spojeném přesouvání.
//     */
//    @Test
//    public void testIShape()
//    {
//        Multishape set = new Multishape(
//                             lightXY, lightXYC, lightXYS, lightXYSC);
//        CM.removeAll();
//        CM.add(set);
//        Resizer resizer = new Resizer(5);
//        resizer.resizeTo(CM.getWidth(), CM.getHeight(), set);
//        resizer.resizeTo(1, 1, set, Direction8.SOUTH_EAST);
//        resizer.resizeTo(CM.getWidth(), CM.getHeight(), set,
//                           Direction8.SOUTH_EAST);
//    }
//
//
//    /********************************************************************
//     * Ověří na příkladu záměny světel, že světla umějí
//     * vrátit svoji pozici a nastavit zadanou pozici.
//     */
//    @Test
//    public void testMovable()
//    {
//        Position positionXY   = lightXY  .getPosition();
//        Position positionXYS  = lightXYS .getPosition();
//        Position positionXYC  = lightXYC .getPosition();
//        Position positionXYSC = lightXYSC.getPosition();
//
//        lightXYS.setPosition(positionXYSC);
//        assertEquals(positionXYSC, lightXYS.getPosition());
//        lightXYSC.setPosition(positionXYS);
//        assertEquals(positionXYS, lightXYSC.getPosition());
//
//        lightXY.setPosition(positionXYC);
//        assertEquals(positionXYC, lightXY.getPosition());
//        lightXYC.setPosition(positionXY);
//        assertEquals(positionXY, lightXYC.getPosition());
//    }
//
//
//    /**************************************************************************
//     * Prověří, že světlo umí zapnout nezávislé blikání -
//     * nechá světlo blikat zatímco je přesouvané přesouvačem.
//     */
//    @Test
//    public void testMoveAndBlink()
//    {
//        lightXYS.blink(10);                 //Spustí se blikání a ...
//        Mover mover = new Mover(2);
//        mover.moveTo(200, 200, lightXYS);   //blikající světlo se přesune
//    }
//
//
//    /**************************************************************************
//     * Prověří, že světlo vyhodí chybu {@link AssertionError} v případě,
//     * kdy je bude chtít někdo rozblikat před ukončením předchozího blikání.
//     */
//    @Test()
//    public void testDoubleBlinkingError()
//    {
//        assertThrows(AssertionError.class,
//        () -> {
//            lightXYS.blink(3);
//            lightXYS.blink(3);
//        });
//        IO.inform("Sem to vůbec nemělo dojít");
//    }
//
//
//    /**************************************************************************
//     * Prověří, že světlo vyhodí chybu {@link AssertionError} v případě,
//     * kdy bude požádáno o zastavení blikání neblikajícího světla.
//     */
//    @Test()
//    public void testWrongStopBlinking()
//    {
//        assertThrows(AssertionError.class,
//                     () -> lightXYS.stopBlinking());
//        IO.inform("Sem to vůbec nemělo dojít");
//    }
//
//
//    /**************************************************************************
//     * Prověří, že blikání lze předčasně ukončit
//     * a že stejně dobře lze reagovat i na konec zadaného blikání.
//     */
//    @Test
//    public void testStoppedMovingAndBlinking()
//    {
//        //První test zastaví přesun světla poté, co dobliká
//        Multimover multimover = Multimover.getInstance();
//        lightXYS.blink(10, 250,
//                       () -> { multimover.stop(lightXYS); });
//        multimover.moveWithSpeed(50, lightXYS, 200, 200);
//
//        //Druhý test zastaví blikání v okamžiku, kdy světlo dojede do cíle
//        lightXYSC.blink(0, 150);
//        multimover.moveWithSpeed(50, lightXYSC, 0, 200,
//                                 (m) -> { ((BlinkingLight)m).stopBlinking(); } );
//    }
//
//
//    /**************************************************************************
//     * Ověří funkčnost konstruktoru nastavujícího také tvar žárovky.
//     */
//@Test
//public void testBulbShape()
//{
//    CM.removeAll();
//    lightXY    = changeShape(lightXY,  Rectangle::new);
//    lightXYC   = changeShape(lightXYC, Triangle::new);
//    lightXYS   = changeShape(lightXYS, () ->
//                 new Triangle(0, 0, 1, 1, Direction8.SOUTH_WEST));
//    CM.add(lightXY, lightXYC, lightXYS, lightXYSC);
//}
//
//
//    /**************************************************************************
//     * Ověří funkčnosti metody {@code copy} při použití různých tvarů žárovky.
//     */
//    @Test
//    public void testCopy()
//    {
//        testBulbShape();
//        lightXYS  = lightXYS .copy();
//        lightXYSC = lightXYSC.copy();
//        CM.add(lightXYC, lightXYS);
//        testStoppedMovingAndBlinking();
//    }
//
//
//    /***************************************************************************
//     * Test metody {@link #setUp()} vytvářející testovací přípravek.
//     */
//    @Test
//    public void testSetUp()
//    {
//    }

}
