/* Saved in UTF-8 codepage: Příliš žluťoučký kůň úpěl ďábelské ódy. ÷ × ¤
 * Check: «Stereotype», Section mark-§, Copyright-©, Alpha-α, Beta-β, Smile-☺
 */
package ruplib.canvasmanager;



/*******************************************************************************
 * Interfejs {@code ICMPaintable} musí implementovat všechny třídy, které chtějí,
 * aby jejich instance byly přijaty do správy instance {@link CanvasManager}.
 * Ta vyžaduje, aby se jí spravované objekty uměly na požádání nakreslit
 * prostřednictvím dodaného kreslítka.
 * <p>
 * Implementací tohoto rozhraní třída současně slibuje, že bude správce plátna
 * okamžitě informovat o jakýchkoliv změnách ve svém umístění a vzhledu,
 * které chce promítnout do své podoby na plátně. O tom, že se něco změnilo
 * informuje (kdo-instance &ndash;&gt; koho) objekt správce plátna
 * zavoláním jeho metody {@link CanvasManager#repaint()}.
 *
 * @author  Rudolf PECINOVSKÝ
 * @version 2023-Summer
 */
public interface ICMPaintable
{
//\CC== CLASS (STATIC) CONSTANTS ===============================================

    /** Správce plátna &ndash; instance třídy {@link CanvasManager},
     *  která má na starosti zobrazování objektů na plátně
     *  a u níž musíme registrovat všechny objekty,
     *  které mají být zobrazovány na plátně.
     *  Správce plátna je jedináček, takže jej všichni sdílí. */
    CanvasManager CM = CanvasManager.getInstance(false);



//\CM== CLASS (STATIC) METHODS =================================================



//##############################################################################
//\AG== ABSTRACT GETTERS AND SETTERS ===========================================
//\AM== REMAINING ABSTRACT METHODS =============================================

    /***************************************************************************
     * Prostřednictvím dodaného kreslítka vykreslí obraz své instance.
     *
     * @param painter Kreslítko schopné kreslit na plátno ovládané správcem
     */
//     @Override
    public void paint(Painter painter);



//\DG== DEFAULT GETTERS AND SETTERS ============================================
//\DM== REMAINING DEFAULT METHODS ==============================================

    /***************************************************************************
     * Přihlásí se u správce plátna, a tím zabezpečí své zobrazování.
     */
    default
    public void show()
    {
        CM.add(this);
    }


    /***************************************************************************
     * Odhlásí se u správce plátna, a tím zruší své zobrazování.
     */
    default
    public void hide()
    {
        CM.remove(this);
    }



//##############################################################################
//\NT== NESTED DATA TYPES ======================================================
}
