/* Saved in UTF-8 codepage: Příliš žluťoučký kůň úpěl ďábelské ódy. ÷ × ¤
 * Check: «Stereotype», Section mark-§, Copyright-©, Alpha-α, Beta-β, Smile-☺
 */
package ruplib.geom;



/*******************************************************************************
* Instance interfejsu {@code IMovable} představují objekty,
 * které umějí prozradit a nastavit svoji pozici.
 * Tato pozice je implicitně definována jako pozice
 * levého horního rohu opsaného obdélníku.
*
 * @author  Rudolf PECINOVSKÝ
 * @version 2023-Summer
 */
public interface IMovable
{
//\CC== CLASS (STATIC) CONSTANTS ===============================================
//\CM== CLASS (STATIC) METHODS =================================================



//##############################################################################
//\AG== ABSTRACT GETTERS AND SETTERS ===========================================

    /***************************************************************************
     * Vrátí x-ovou (vodorovnou) souřadnici pozice instance,
     * tj. vodorovnou souřadnici levého horního rohu opsaného obdélníku.
     *
     * @return  Aktuální vodorovná (x-ová) souřadnice instance,
     *          x=0 má levý okraj plátna, souřadnice roste doprava
     */
//    @Override
    public int getX();


    /***************************************************************************
     * Vrátí y-ovou (svislou) souřadnici pozice instance,
     * tj. svislou souřadnici levého horního rohu opsaného obdélníku.
     *
     * @return  Aktuální svislá (y-ová) souřadnice instance,
     *          y=0 má horní okraj plátna, souřadnice roste dolů
     */
//    @Override
    public int getY();


    /***************************************************************************
     * Přemístí instanci na zadanou pozici.
     * Pozice instance je přitom definována jako pozice
     * levého horního rohu opsaného obdélníku.
     *
     * @param x  Nově nastavovaná vodorovná (x-ová) souřadnice instance,
     *           x=0 má levý okraj plátna, souřadnice roste doprava
     * @param y  Nově nastavovaná svislá (y-ová) souřadnice instance,
     *           y=0 má horní okraj plátna, souřadnice roste dolů
     */
//    @Override
    public void setPosition(int x, int y);



//\AM== REMAINING ABSTRACT METHODS =============================================
//\DG== DEFAULT GETTERS AND SETTERS ============================================

    /***************************************************************************
     * Vrátí instanci třídy {@code Position} s aktuální pozicí instance.
     *
     * @return  Instance třídy {@code Position} s aktuální pozicí instance
     */
    default
    public Position getPosition()
    {
        return new Position(getX(), getY());
    }


    /***************************************************************************
     * Nastaví novou pozici instance.
     *
     * @param position   Nastavovaná pozice instance
     */
    default
    public void setPosition(Position position)
    {
        setPosition(position.x, position.y);
    }


    /***************************************************************************
     * Nastaví x-ovou (vodorovnou) souřadnici pozice instance,
     * tj. vodorovnou souřadnici levého horního rohu opsaného obdélníku.
     *
     * @param x  Nastavovaná vodorovná (x-ová) souřadnice instance,
     *           x=0 má levý okraj plátna, souřadnice roste doprava
     */
    default
    public void setX(int x)
    {
        setPosition(x, getY());
    }


    /***************************************************************************
     * Nastaví y-ovou (svislou) souřadnici pozice instance,
     * tj. svislou souřadnici levého horního rohu opsaného obdélníku.
     *
     * @param y Nastavovaná svislá (y-ová) souřadnice instance,
     *          y=0 má horní okraj plátna, souřadnice roste dolů
     */
    default
    public void setY(int y)
    {
        setPosition(getX(), y);
    }



//\DM== REMAINING DEFAULT METHODS ==============================================

    /***************************************************************************
     * Přesune instanci o zadaný počet bodů vpravo,
     * při záporné hodnotě parametru vlevo.
     *
     * @param distance Vzdálenost, o kterou se instance přesune
     */
    default
    public void moveRight(int distance)
    {
        setPosition(getX()+distance, getY());
    }


    /***************************************************************************
     * Přesune instanci o zadaný počet bodů dolů,
     * při záporné hodnotě parametru nahoru.
     *
     * @param distance   Počet bodů, o které se instance přesune
     */
    default
    public void moveDown(int distance)
    {
        setPosition(getX(), getY()+distance);
    }



//##############################################################################
//\NT== NESTED DATA TYPES ======================================================
}
