/* Saved in UTF-8 codepage: Příliš žluťoučký kůň úpěl ďábelské ódy. ÷ × ¤
 * Check: «Stereotype», Section mark-§, Copyright-©, Alpha-α, Beta-β, Smile-☺
 */
package ruplib.geom;



/*******************************************************************************
* Instance interfejsu {@code IResizeable} představují objekty,
 * které umějí prozradit a nastavit svoje rozměry.
 * Rozměry instance jsou přitom definovány jako rozměry
 * opsaného obdélníku.
*
 * @author  Rudolf PECINOVSKÝ
 * @version 2023-Summer
 */
public interface IResizable
{
//\CC== CLASS (STATIC) CONSTANTS ===============================================
//\CM== CLASS (STATIC) METHODS =================================================



//##############################################################################
//\AG== ABSTRACT GETTERS AND SETTERS ===========================================

    /***************************************************************************
     * Vrátí aktuální šířku instance.
     * Šířka instance jsou přitom definována jako šířka
     * opsaného obdélníku.
     *
     * @return  Aktuální šířka instance
     */
//     @Override
    public int getWidth();


    /***************************************************************************
     * Vrátí aktuální výšku instance.
     * Výška instance jsou přitom definována jako výška
     * opsaného obdélníku.
     *
     * @return  Aktuální výška instance
     */
//     @Override
    public int getHeight();


    /***************************************************************************
     * Nastaví nové rozměry instance.
     * Rozměry instance jsou přitom definovány jako rozměry
     * opsaného obdélníku.
     * Nastavované rozměry musí být nezáporné,
     * místo nulového rozměru se nastaví rozměr rovný jedné.
     *
     * @param width   Nově nastavovaná šířka; šířka &gt;= 0
     * @param height  Nově nastavovaná výška; výška &gt;= 0
     */
//     @Override
   public void setSize(int width, int height);



//\AM== REMAINING ABSTRACT METHODS =============================================
//\DG== DEFAULT GETTERS AND SETTERS ============================================

   /***************************************************************************
     * Vrátí instanci třídy {@code Size} s aktuálními rozměry instance.
     *
     * @return   Instance třídy {@code Size} s aktuálními rozměry instance
     */
   default
    public Size getSize()
    {
        return new Size(getWidth(), getHeight());
    }


    /***************************************************************************
     * Nastaví nové rozměry instance.
     * Nastavované rozměry musí být nezáporné,
     * místo nulového rozměru se nastaví rozměr rovný jedné.
     *
     * @param size  Nově nastavované rozměry
     */
    default
    public void setSize(Size size)
    {
        setSize(size.width, size.height);
    }


    /***************************************************************************
     * Nastaví nový "čtvercový" rozměr instance -
     * na zadaný rozměr se nastaví výška i šířka.
     * Rozměry instance jsou přitom definovány jako rozměry
     * opsaného obdélníku.
     * Nastavované rozměry musí být nezáporné,
     * místo nulového rozměru se nastaví rozměr rovný jedné.
     *
     * @param size  Nově nastavovaný rozměr v obou směrech; rozměr &gt;= 0
     */
    default
    public void setSize(int size)
    {
        setSize(size, size);
    }


    /***************************************************************************
     * Nastaví novou šířku (vodorovný rozměr) instance.
     *
     * @param width Nově nastavovaná šířka; šířka &gt;= 0
     */
    default
    public void setWidth(int width)
    {
        setSize(width, getHeight());
    }


    /***************************************************************************
     * Nastaví novou výšku (vodorovný rozměr) instance.
     *
     * @param height Nově nastavovaná výška; výška &gt;= 0
     */
    default
    public void setHeight(int height)
    {
        setSize(getWidth(), height);
    }



//\DM== REMAINING DEFAULT METHODS ==============================================



//##############################################################################
//\NT== NESTED DATA TYPES ======================================================
}
