/* Saved in UTF-8 codepage: Příliš žluťoučký kůň úpěl ďábelské ódy. ÷ × ¤
 * Check: «Stereotype», Section mark-§, Copyright-©, Alpha-α, Beta-β, Smile-☺
 */
package ruplib.geom;



/*******************************************************************************
 * Instance rozhraní {@code ITurnable8} představují objekty,
 * které se umějí otáčet do osmi hlavních a vedlejších světových stran.
 *
 * @author  Rudolf PECINOVSKÝ
 * @version 2023-Summer
 */
public interface ITurnable8 extends ITurnable4
{
//\CC== CLASS (STATIC) CONSTANTS ===============================================
//\CM== CLASS (STATIC) METHODS =================================================



//##############################################################################
//\AG== ABSTRACT GETTERS AND SETTERS ===========================================

    /***************************************************************************
     * Vrátí směr, do nějž je daná instance natočena.
     *
     * @return Směr, do nějž je daná instance natočena
     */
    @Override
    public Direction8 getDirection();



//\AM== REMAINING ABSTRACT METHODS =============================================

    /***************************************************************************
     * Otočí instanci o 90° vlevo.
     */
    public void halfLeft();


    /***************************************************************************
     * Otočí instanci o 90° vpravo.
     */
    public void halfRight();



//\DG== DEFAULT GETTERS AND SETTERS ============================================

    /***************************************************************************
     * Otočí instanci do zadaného směru.
     *
     * @param direction Směr, do nějž má být instance otočena
     */
    public default void setDirection8(Direction8 direction)
    {
        direction.turnTo8(this);
    }



//\DM== REMAINING DEFAULT METHODS ==============================================

    /***************************************************************************
     * Otočí instanci do zadaného směru.
     * Je to pouze jinak pojmenovaná metoda {@link #setDirection(Direction8) },
     * aby její název odpovídal duchu ostatních "otáčecích" metod.
     *
     * @param direction Směr, do nějž má být instance otočena
     */
    public default void turnTo8(Direction8 direction)
    {
        direction.turnTo8(this);
    }



//##############################################################################
//\NT== NESTED DATA TYPES ======================================================
}
