/* Saved in UTF-8 codepage: Příliš žluťoučký kůň úpěl ďábelské ódy. ÷ × ¤
 * Check: «Stereotype», Section mark-§, Copyright-©, Alpha-α, Beta-β, Smile-☺
 */
package ruplib.util;



/*******************************************************************************
 * Instance rozhraní {@code IAuthor} umějí na požádání vrátit
 * jméno a identifikační kód (login) autora/autorky své třídy.
 *
 * @author  Rudolf PECINOVSKÝ
 * @version 2023-Summer
 */
public interface IAuthor
{
//\CC== CLASS (STATIC) CONSTANTS ===============================================
//\CM== CLASS (STATIC) METHODS =================================================



//##############################################################################
//\AG== ABSTRACT GETTERS AND SETTERS ===========================================

    /***************************************************************************
     * Vrátí jméno autora/autorky ve formátu <b>PŘÍJMENÍ Křestní</b>,
     * t.j. nejprve příjmení zapsané velkými písmeny a za ním křestní jméno
     * zapsané malými písmeny s prvním písmenem velkým.
     * Má-li autor(ka) více křestních jmen, uvede všechna.
     *
     * @return Jméno autora/autorky programu ve tvaru <i>PŘÍJMENÍ Křestní</i>
     */
//    @Override
    public String getAuthorName()
    ;


    /***************************************************************************
     * Vrátí identifikační řetězec autora/autorky zapsaný velkými písmeny.
     * Identifikačním řetězcem je ve většině případů jeho školní login.
     *
     * @return Identifikační řetězec autora/autorky
     */
//    @Override
    public String getAuthorID()
    ;



//\AM== REMAINING ABSTRACT METHODS =============================================
//\DG== DEFAULT GETTERS AND SETTERS ============================================
//\DM== REMAINING DEFAULT METHODS ==============================================

    /***************************************************************************
     * Vrátí řetězec tvožený identifikačním řetězcem autora/autorky
     * následovaným dlouhou pomlčkou a jeho příjmením a jménem.
     * Metoda obchází nemožnost přebití metody {@code toString()}.
     *
     * @return Author ID and name
     */
    public default String getAuthorString()
    {
        return getAuthorID() + " — " + getAuthorName();
    }



//##############################################################################
//\NT== NESTED DATA TYPES ======================================================
}
