/* The file is saved in UTF-8 codepage.
 * Check: «Stereotype», Section mark-§, Copyright-©, Alpha-α, Beta-β, Smile-☺
 */
package ruplib.util;

import java.io.InputStream;
import java.io.InputStreamReader;

import java.nio.charset.Charset;



/*******************************************************************************
 * Instance třídy {@code InputStreamUTF8Reader} představují dekorátory
 * obalující zadaný vstupní proud typu {@link InputStream}
 * a vytvářející znakový datový proud čtoucí texty kódované v UTF-8.
 *
 * @author  Rudolf PECINOVSKÝ
 * @version 2023-Summer
 */
public class InputStreamUTF8Reader
     extends InputStreamReader
{
//== CONSTANT CLASS ATTRIBUTES =================================================

    /** Znaková sada UTF-8. */
    private static final Charset UTF8 = Charset.forName("UTF-8");



//== VARIABLE CLASS ATTRIBUTES =================================================



//##############################################################################
//== STATIC INITIALIZER (CLASS CONSTRUCTOR) ====================================
//== CLASS GETTERS AND SETTERS =================================================
//== OTHER NON-PRIVATE CLASS METHODS ===========================================
//== PRIVATE AND AUXILIARY CLASS METHODS =======================================



//##############################################################################
//== CONSTANT INSTANCE ATTRIBUTES ==============================================
//== VARIABLE INSTANCE ATTRIBUTES ==============================================



//##############################################################################
//== CONSTRUCTORS AND FACTORY METHODS ==========================================

    /***************************************************************************
     * Vytvoří {@link InputStreamReader} pracující se zdrojovými soubory
     * kódovanými v UTF-8 vzniklý obalením zadaného vstupního proudu.
     *
     * @param in Obalovaný {@link InputStream}
     */
    public InputStreamUTF8Reader(InputStream in)
    {
        super(in, UTF8);
    }



//== ABSTRACT METHODS ==========================================================
//== INSTANCE GETTERS AND SETTERS ==============================================
//== OTHER NON-PRIVATE INSTANCE METHODS ========================================
//== PRIVATE AND AUXILIARY INSTANCE METHODS ====================================



//##############################################################################
//== NESTED DATA TYPES =========================================================
}
